
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <map>
#include <math.h>
#include <stdio.h>
#include <limits>
#include <bitset>

using namespace std;

map<int, vector<int>> globalHowToGetToCity;
int globalN;

bitset<100000> visitedCities;
int visitedCitiesSize = 0;
vector<int> road;

vector<int> makeCycle (int startCity) {
    road[visitedCitiesSize] = startCity;
    visitedCities[startCity] = 1;
    visitedCitiesSize++;


    if (visitedCitiesSize == globalN) {
        vector<int> gHTGTCSC = globalHowToGetToCity[startCity];
        if (find(gHTGTCSC.begin(), gHTGTCSC.end(), 1) != gHTGTCSC.end()) {
            road[globalN] = 1;
            return road;
        }
        visitedCities[startCity] = 0;
        visitedCitiesSize--;
        return { -1 };
    }

    for (int city : globalHowToGetToCity[startCity]) {
        if (!visitedCities[city]) {
            vector<int> cycle = makeCycle(city);
            if (cycle[0] != -1) {
                return cycle;
            }
        }
    }
    visitedCities[startCity] = 0;
    visitedCitiesSize--;
    return { -1 };
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    
    int n, m;
    cin >> n >> m;

    globalN = n;

    vector<int> r(n + 1);
    road = r;

    map<int, vector<int>> howToGetToCity;


    int j = 0;

    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        howToGetToCity[b].push_back(a);
    }

    globalHowToGetToCity = howToGetToCity;

    vector<int> result = {-1};

    result = makeCycle(1);
    
    if (result[0] == -1) {
        printf("NO");
        return 0;
    }
    printf("YES\n");
    for (int i = n; i >= 0; i--) {
        printf("%i ", result[i]);
    }

    
    
}
